'use strict';

function StudentRemoveSelectedModalCtrl($scope, $rootScope){
    $scope.group = {};
    $scope.students = [];

    $scope.removeStudentsProgress = false;

    $scope.$on('Groups:removeSelectedStudentsModal', function(event, group){
        $scope.group = group;
        $scope.students = [];

        angular.forEach($scope.group.users, function(student){
            if(student._selected)
            {
                $scope.students.push(student);
            }
        })
        $scope.openModal();
    });


    $scope.openModal = function(){
        angular.element('#modal-student-remove-selected').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-student-remove-selected').modal('hide');
    }


    $scope.removeStudents = function(){
        var i = $scope.students.length;
        $scope.removeStudentsProgress = true;
        angular.forEach($scope.students, function(student){
            student.destroy(function(){
                var index = $scope.group.users.indexOf($scope.student);
                $scope.group.users.splice(index, 1);
                i--;
                if(i == 0)
                {
                    $scope.removeStudentsProgress = false;
                    $scope.closeModal();
                }
            })
        });
    }
}

StudentRemoveSelectedModalCtrl.$inject = ['$scope', '$rootScope'];